<!DOCTYPE html>
<html lang="pt-br">
<head>

        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">


        <title>Clientes</title>
        <meta name="description" content="Desde 2007, muitos clientes atendidos e satisfeitos.">
        <meta name="robots" content="index, follow">
		<meta name="author" content="Web designer Rodrigo Marafigo">



        <meta property="og:locale" content="pt_BR">
        <meta property="og:url" content="https://rodrigomarafigo.com.br">
        <meta property="og:title" content="Clientes">
        <meta property="og:site_name" content="Rodrigo Marafigo • Desenvolvimento Web">
        <meta property="og:description" content="Desde 2007, muitos clientes atendidos e satisfeitos.">
        <meta property="og:image" content="/img/ilustracao_desenvolvimento.jpg">
        <meta property="og:type" content="website">


        <?php

            include("ico.php");

            include("style.php");

        ?>

</head>
<body>

    <?php

        include("nav.php");

    ?>

        <div class="sidebar-wrapper mobile-height">


            <section class="wow fadeIn">

                <div class="container">

                    <div class="row sm-padding-100px-top">

                        <div class="col-lg-11 col-md-11 col-sm-12 col-xs-12 center-col no-margin-bottom sm-padding-20px-top text-center">

                            <h1 class="alt-font font-weight-300 margin-25px-bottom text-very-large text-uppercase text-purple"><strong>Clientes</strong> em Todo o Brasil</h1>

                        </div>  

                    </div>

                    <div class="row">

                        <div class="col-lg-6 col-md-8 col-sm-8 col-xs-12 center-col text-center margin-80px-bottom">

                            <div class="position-relative overflow-hidden width-100">

                                <h2 class="text-medium text-outside-line-full alt-font text-blue font-weight-600 text-uppercase">PROJETOS RECENTES</h2>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-md-12 no-padding xs-padding-15px-lr wow fadeIn">

                            <div class="filter-content overflow-hidden">

                                <ul class="portfolio-grid work-1col gutter-medium hover-option6 lightbox-portfolio">

                                    <li class="grid-sizer"></li>
                                    
                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_cocal_transportes.jpg" alt="Criação de Site em Uberlândia" title="Web Design em Uberlândia">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-medium btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://cocaltransportes.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Cocal Transportes</div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Uberlândia / MG</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_amendex.jpg" alt="Criação de Site em Bandeirantes" title="Web Design em Bandeirantes">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-medium btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://amendex.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Amendex <span class="font-weight-700">#Alimentos</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Bandeirantes / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/postos_v_brambila.jpg" alt="Criação de Site em Apucarana" title="Web Design em Apucarana">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-medium btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://postosvbrambila.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Postos V. Brambila</div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/agencia_brasileira_de_talentos_criativos.jpg" alt="Criação de Site para agencia de modelos" title="Web Design para agencia de modelos">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://abtcagenciamento.com/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Agência Brasileira de Talentos Criativos</div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">São Paulo / SP</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_fabio_oliver.jpg" alt="Criação de Site para advocacia" title="Web Design para advocacia">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://fabiooliver.com/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Fábio Oliver <span class="font-weight-700">#Advocacia</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Uberaba / MG</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_petroni_e_petroni.jpg" alt="Criação de Site para advocacia" title="Web Design para advocacia">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://www.petroniadv.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Petroni & Petroni <span class="font-weight-700">#Advocacia</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">São Paulo / SP</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_lebi.jpg" alt="Criação de Site para construtora" title="Web Design para construtora">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://lebiconstrutora.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Lebi <span class="font-weight-700">#Construtora</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/cavalheiro_advocacia.jpg" alt="Criação de Site em Apucarana" title="Web Design em Apucarana">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-medium btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://cavalheiroadvocacia.adv.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Cavalheiro <span class="font-weight-700">#Advocacia</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/barrak.jpg" alt="Criação de Site em São Paulo" title="Web Design em São Paulo">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-medium btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://barrak.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Barrak <span class="font-weight-700">#Cnidários</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">São Paulo / SP</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_novaagri.jpg" alt="Criação de Site para o segmento Agro" title="Web Design para o segmento Agro">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://novaagri.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">NovaAgri <span class="font-weight-700">#Agro</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">São Paulo / SP</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_pennacchi.jpg" alt="Criação de Site em Arapongas" title="Web Design em Arapongas">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://pennacchi.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Pennacchi <span class="font-weight-700">#Distribuidora</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Arapongas / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_vbrasil.jpg" alt="Criação de Site em Maringá" title="Web Design em Maringá">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://vbrasillog.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Vbrasil <span class="font-weight-700">#Logística</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Maringá / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/dobue.jpg" alt="Criação de Site em Sabáudia" title="Web Design em Sabáudia">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-medium btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://dobue.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Dobuê <span class="font-weight-700">#Movelaria</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Sabáudia / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_w3f.jpg" alt="Criação de Site em Curitiba" title="Web Design em Curitiba">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://w3f.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">w3F <span class="font-weight-700">#Tecnologia</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Curitiba / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                </ul>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-lg-6 col-md-8 col-sm-8 col-xs-12 center-col text-center padding-40px-top margin-80px-bottom wow fadeInDown">

                            <div class="position-relative overflow-hidden width-100">

                                <span class="text-extra-large text-outside-line-full alt-font font-weight-600 text-uppercase text-orange">PROJETOS MAIS ANTIGOS</span>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-md-12 no-padding xs-padding-15px-lr wow fadeIn">

                            <div class="filter-content overflow-hidden">

                                <ul class="portfolio-grid work-1col gutter-medium hover-option6 lightbox-portfolio">

                                    <li class="grid-sizer"></li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_lebimix.jpg" alt="Criação de Site em Apucarana" title="Web Design em Apucarana">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://lebimix.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Lebimix <span class="font-weight-700">#Concreteira</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_archluvi.jpg" alt="Criação de Site em Londrina" title="Web Design em Londrina">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://archluvi.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">ArchLuvi <span class="font-weight-700">#Arquitetura</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Londrina / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_31.jpg" alt="Criação de Site em Curitiba" title="Web Design em Curitiba">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://wvetro.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">WVetro <span class="font-weight-700">#Software</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Curitiba / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_2.jpg" alt="Criação de Site em Santo André" title="Web Design em Santo André">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="http://multiservicelog.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Multiservice <span class="font-weight-700">#Logística</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Santo André / SP</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_rudrack.jpg" alt="Criação de Site em Rolândia" title="Web Design em Rolândia">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://rudrack.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Rud Rack <span class="font-weight-700">#Móveis</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Rolândia / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_3.jpg" alt="Criação de Site em Rio de Janeiro" title="Web Design em Rio de Janeiro">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="http://www.mvengenharia.com/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">MV <span class="font-weight-700">#Engenharia</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Rio de Janeiro / RJ</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_4.jpg" alt="Criação de Site em Jacarezinho" title="Web Design em Jacarezinho">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://www.cargomodal.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">CargoModal <span class="font-weight-700">#Transportes</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_reduzaja.jpg" alt="Criação de Site em Cambé" title="Web Design em Cambé">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://reduzaja.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Reduzajá <span class="font-weight-700">#Telefonia</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Cambé / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_5.jpg" alt="Criação de Site em Londrina" title="Web Design em Londrina">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://www.rabelloadvocacia.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Rabello <span class="font-weight-700">#Advocacia</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Londrina / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_29.jpg" alt="Criação de Site em Bandeirantes" title="Web Design em Bandeirantes">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://edluma.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Edluma <span class="font-weight-700">#Alimentos</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Bandeirantes / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_6.jpg" alt="Criação de Site em Maringá" title="Web Design em Maringá">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://legadoenergias.com/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Legado <span class="font-weight-700">#EnergiaSolar</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Maringá / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_7.jpg" alt="Criação de Site em Bauru" title="Web Design em Bauru">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://ipeazul.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Ipê Azul <span class="font-weight-700">#Construtora</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Bauru / SP</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/showcase_brambila.jpg" alt="Criação de Site em Arapongas" title="Web Design em Arapongas">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="http://www.brambilatransportes.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Brambila <span class="font-weight-700">#Transportes</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Arapongas / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_27.jpg" alt="Criação de site em Maringá" title="Web Design em Maringá">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="http://www.elevnorte.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Elevnorte <span class="font-weight-700">#Elevadores</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Maringá / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_10.jpg" alt="Criação de Site em Apucarana" title="Web Design em Apucarana">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="http://emporiostampe.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Empório Stampe <span class="font-weight-700">#Estamparia</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_12.jpg" alt="Criação de Site em Apucarana" title="Web Design em Apucarana">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="http://globexpress.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Globex <span class="font-weight-700">#Confecções</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_28.jpg" alt="Criação de Site em Apucarana" title="Web Design em Apucarana">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://mastercrn.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Master CRN <span class="font-weight-700">#Confecções</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_15.jpg" alt="Criação de Site em Apucarana" title="Web Design em Apucarana">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://com-artexpositores.com/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Com Art <span class="font-weight-700">#Expositores</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_18.jpg" alt="Criação de Site em Londrina" title="Web Design em Londrina">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://fastperola.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Fast Pérola <span class="font-weight-700">#Transportes</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Londrina / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_20.jpg" alt="Criação de Site em Apucarana" title="Web Design em Apucarana">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://crrbonesecarteiras.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">CRR <span class="font-weight-700">#Confecções</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_23.jpg" alt="Criação de Site em Arapongas" title="Web Design em Arapongas">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="https://www.moveiscanaa.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Canaã <span class="font-weight-700">#MóveisInfantis</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Arapongas / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_24.jpg" alt="Criação de Site em Curitiba" title="Web Design em Curitiba">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="http://obatrade.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Obatrade <span class="font-weight-700">#Importação</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Curitiba / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                    <li class="grid-item wow fadeIn last-paragraph-no-margin">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <img src="/img/ptf_25.jpg" alt="Criação de Site em Apucarana" title="Web Design em Apucarana">

                                                <div class="overlay-content text-center">

                                                    <div class="display-table height-100 width-100">

                                                        <div class="vertical-align-middle display-table-cell">

                                                            <a class="btn btn-small btn-blue md-margin-15px-bottom sm-display-table sm-margin-lr-auto" href="http://www.bunnetbrindes.com.br/" target="_blank">Ver Projeto</a>

                                                        </div>

                                                    </div>

                                                </div>

                                            </div>

                                            <figcaption class="pdd-12px">

                                                <div class="team-member-position no-margin-top text-center">

                                                    <div class="alt-font text-small font-weight-400 text-extra-dark-gray text-uppercase">Bunnet <span class="font-weight-700">#Confecções</span></div>

                                                    <div class="text-extra-small alt-font text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </li>

                                </ul>

                            </div>

                        </div>

                    </div>

                </div>

            </section>


            <?php

                include("footer.php");

            ?>

        </div>

        <?php

            include("js.php");

        ?>

</body>
</html>