<!DOCTYPE html>
<html lang="pt-br">
<head>

        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">


        <title>Contato</title>
        <meta name="description" content="Converse com o Rodrigo Marafigo, esclareça suas dúvidas.">
		<meta name="robots" content="index, follow">	
        <meta name="author" content="Web designer Rodrigo Marafigo">



        <meta property="og:locale" content="pt_BR">
        <meta property="og:url" content="https://rodrigomarafigo.com.br/contato">
        <meta property="og:title" content="Contato">
        <meta property="og:site_name" content="Rodrigo Marafigo - Criação de Sites e Marketing Digital">
        <meta property="og:description" content="Converse com o Rodrigo Marafigo, esclareça suas dúvidas.">
        <meta property="og:image" content="/img/ilustracao_desenvolvimento.jpg">
        <meta property="og:type" content="website">

        <?php

            include("ico.php");

            include("style.php");

        ?>

</head>
<body>

    <?php

        include("nav.php");

    ?>

        <div class="sidebar-wrapper mobile-height">

            <section class="wow fadeIn">

                <div class="container wow fadeInRight">

                    <div class="row sm-padding-100px-top">

                        <div class="col-lg-11 col-md-11 col-sm-12 col-xs-12 center-col no-margin-bottom sm-padding-20px-top text-center wow fadeInDown">

                            <h1 class="alt-font font-weight-700 margin-10px-bottom text-uppercase text-multi-large text-purple">Contato</h1>

                        </div>  

                    </div>

                    <div class="row">

                        <div class="col-lg-6 col-md-8 col-sm-8 col-xs-12 center-col text-center margin-80px-bottom wow fadeInDown">

                            <div class="position-relative overflow-hidden width-100">

                                <h2 class="text-small text-outside-line-full alt-font font-weight-600 text-uppercase text-purple">Vamos Conversar</h2>

                            </div>

                        </div>

                    </div>

                    <div class="row"> 

                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 padding-ten-right md-padding-five-right sm-padding-15px-right sm-margin-five-bottom wow fadeInLeft">

                            <div class="icon-box width-100 sm-margin-lr-auto xs-width-100 last-paragraph-no-margin">

                                <div class="icon-box-holder vertical-align-middle display-table-cell position-relative">

                                    <i class="icon-phone icon-medium text-golden padding-5px-top"></i>

                                    <p class="alt-font text-black font-weight-700 margin-10px-bottom">

                                    Suporte:

                                    </p>

                                    <p class="alt-font no-padding-bottom">

                                    (43) 9 9931-3501

                                    </p>

                                    <br/>
                                    
                                    <i class="icon-phone icon-medium text-golden"></i>
                                    
                                    <p class="alt-font text-black font-weight-700 margin-10px-bottom">

                                    Comercial:

                                    </p>

                                    <p class="alt-font no-padding-bottom font-weight-700">

                                    (43) 9 9190-9446

                                    </p>

                                    <br/>
                                    
                                    <i class="icon-phone icon-medium text-golden"></i>
                                    
                                    <p class="alt-font text-black font-weight-700 margin-10px-bottom">

                                    Financeiro:

                                    </p>

                                    <p class="alt-font margin-30px-bottom">

                                    (43) 9 9678-7929

                                    </p>

                                    <br/>

                                    <i class="icon-clock icon-medium text-golden"></i>

                                    <div class="alt-font text-black font-weight-600">

                                    Horário de Atendimento

                                    </div>

                                    <p class="alt-font margin-30px-bottom">

                                    De segunda à sexta-feira dás 08hs às 18hs.

                                    </p>
                                    
                                    <br/>

                                    <i class="icon-map icon-medium text-golden"></i>

                                    <div class="alt-font text-black font-weight-600">

                                    Endereço

                                    </div>

                                    <p class="alt-font padding-40px-bottom">

                                    Rua Pica Pau, nº 115 - Sala 1501 - Centro, CEP: 86701-040, Arapongas / PR • Brasil

                                        <br/><br/>

                                        <span class="alt-font text-black font-weight-600">Atendimento para todo o Brasil.</span>

                                    </p>

                                    <br/>

                                </div>

                            </div>

                        </div>

                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 wow fadeInRight">

                            <div class="padding-fifteen-all bg-very-light-gray md-padding-seven-all">

                                <div class="text-extra-dark-gray text-large font-weight-500 margin-30px-bottom ff_a">

                                Formulário

                                </div> 

                                    <form name="formulario" method="post" action="/lib/email/envia_email.php">

                                        <input type="hidden" name="formulario" value="contato" />

                                        <input type="text" name="nome_visitante" required="" placeholder="Seu Nome *" class="input-bg">

                                        <input type="email" name="email_visitante" required="" placeholder="Email *" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$" class="input-bg">

                                        <input type="text" name="telefone_visitante" placeholder="Telefone" class="input-bg">

                                        <input type="text" name="cidade_uf_visitante" required="" placeholder="Cidade/ UF *" class="input-bg">

                                        <textarea name="mensagem_visitante" required="" placeholder="Mensagem *" class="input-bg"></textarea>

                                        <button type="submit" id="enviar-contato" class="btn btn-small btn-deep-pink md-margin-15px-bottom sm-display-table sm-margin-lr-auto">

                                            Enviar

                                        </button>

                                    </form>

                            </div>

                        </div>

                    </div>

                </div>

            </section>

            <?php

                include("footer.php");

            ?>

        </div>

        <?php

            include("js.php");

        ?>

</body>
</html>