<!DOCTYPE html>
<html lang="pt-br">
<head>

        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">


        <title>Rodrigo Marafigo • Criação de Sites e Marketing Digital</title>
        <meta name="description" content="Clientes como a Cocal Transportes, Pennacchi, MV Engenharia, Amendex, NovaAgri, entre outros.">
        <meta name="robots" content="index, follow">
		<meta name="author" content="Web designer Rodrigo Marafigo">



        <meta property="og:locale" content="pt_BR">
        <meta property="og:url" content="https://rodrigomarafigo.com.br">
        <meta property="og:title" content="Rodrigo Marafigo • Desenvolvimento Web">
        <meta property="og:site_name" content="Rodrigo Marafigo • Desenvolvimento Web">
        <meta property="og:description" content="Clientes como a Cocal Transportes, Pennacchi, MV Engenharia, Amendex, NovaAgri, entre outros.">
        <meta property="og:image" content="/img/ilustracao_desenvolvimento.jpg">
        <meta property="og:type" content="website">

        <?php

            include("ico.php");

            include("style.php");

        ?>

</head>
<body>

    <?php

        include("nav.php");

    ?>

        <div class="sidebar-wrapper mobile-height">

            <section class="wow fadeIn no-padding parallax xs-background-image-center destaque" data-stellar-background-ratio="0.5">

                <div class="container full-screen position-relative wow fadeInUp sm-padding-100px-top xs-padding-80px-top">

                    <div class="slider-typography">

                        <div class="slider-text-middle-main">

                            <div class="slider-text-middle md-padding-15px-lr">

                                <div class="col-lg-12 text-center padding-seven-all md-padding-ten-all sm-text-center wow fadeInUp">

                                    <h1 class="text-white title-small-extra font-weight-400 margin-35px-bottom width-70 md-width-85 sm-width-95 display-inline-block sm-margin-25px-bottom xs-margin-15px-bottom alt-font" title="Desde 2007"><span class="text-blue-ocean font-weight-700">Criação de Sites</span> e <span class="text-blue-ocean font-weight-700">Marketing Digital</span></h1>

                                </div>

                            </div>

                            <div class="down-section text-center">

                                <a href="#mais" class="section-link up-down-ani"><i class="ti-mouse icon-medium bounce text-blue-ocean"></i></a>

                            </div>

                        </div>

                    </div>

                </div>

            </section>





            <section id="mais" class="wow fadeIn bg-light-gray">

                <div class="container-fluid no-padding">

                    <div class="row">

                        <div class="col-lg-12 margin-three-bottom sm-margin-30px-bottom xs-margin-20px-bottom text-center">

                            <h2 class="alt-font font-weight-600 text-very-large margin-30px-bottom text-uppercase text-purple wow fadeInUp">Clientes</h2>

                        </div>  

                    </div>

                    <div class="row margin-two-lr">

                        <div class="position-relative">

                            <div class="swiper-container black-move blog-slider swiper-three-slides swiper-pagination-bottom">

                                <div class="swiper-wrapper mb25">

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="https://cocaltransportes.com.br/" target="_blank"><img src="/img/showcase_mobile_cocal.jpg" alt="Criação de Site em Uberlândia"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">Cocal Transportes</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">Uberlândia / MG</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="https://abtcagenciamento.com/" target="_blank"><img src="/img/agencia_brasileira_de_talentos_criativos_mbl.jpg" alt="Criação de Site em São Paulo"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">ABTC</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">São Paulo / SP</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="https://postosvbrambila.com.br/" target="_blank"><img src="/img/postos_v_brambila_mbl.jpg" alt="Criação de Site em Apucarana"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">Postos V. Brambila</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="https://amendex.com.br/" target="_blank"><img src="/img/showcase_mobile_amendex.jpg" alt="Criação de Site em Bandeirantes"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">Amendex</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">Bandeirantes / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="https://fabiooliver.com/" target="_blank"><img src="/img/showcase_mobile_fabio.jpg" alt="Criação de Site em Uberaba"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">Fábio Oliver Advocacia</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">Uberaba / MG</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="https://petroniadv.com.br/" target="_blank"><img src="/img/showcase_mobile_petroni.jpg" alt="Criação de Site em São Paulo"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">Petroni & Petroni</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">São Paulo / SP</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="https://pennacchi.com.br/" target="_blank"><img src="/img/showcase_mobile_pennacchi.jpg" alt="Criação de Site em Arapongas"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">Pennacchi</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">Arapongas / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="https://novaagri.com.br/" target="_blank"><img src="/img/showcase_mobile_novaagri.jpg" alt="Criação de Site em São Paulo"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">NovaAgri</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">São Paulo / SP</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="http://www.brambilatransportes.com.br/" target="_blank"><img src="/img/showcase_mobile_brambila.jpg" alt="Criação de Site em Arapongas"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">Brambila Transportes</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">Arapongas / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>

                                    <div class="swiper-slide padding-25px-lr team-block text-left team-style-1 md-margin-40px-bottom wow fadeInUp">

                                        <figure>

                                            <div class="team-image xs-width-100">

                                                <a href="https://cavalheiroadvocacia.adv.br/" target="_blank"><img src="/img/cavalheiro_advocacia_mbl.jpg" alt="Criação de Site em Apucarana"></a>

                                            </div>

                                            <figcaption>

                                                <div class="team-member-position margin-20px-top text-center">

                                                    <div class="text-small font-weight-500 text-extra-dark-gray text-uppercase">Cavalheiro Advocacia</div>

                                                    <div class="text-extra-small text-uppercase text-medium-gray">Apucarana / PR</div>

                                                </div>
 
                                            </figcaption>

                                        </figure>

                                    </div>
                              
                                </div>
                     
                                <div class="swiper-pagination-bottom swiper-pagination-three-slides text-center dpl-blc"></div>

                            </div>

                        </div>

                    </div>

                    <div class="padding-20px-top width-100 text-center flt-left">

                        <a href="/clientes" id="ver-projetos" class="btn btn-large btn-deep-pink md-margin-15px-bottom sm-display-table sm-margin-lr-auto">Ver + projetos</a>

                    </div>

                </div>

            </section>



            <section class="wow fadeIn">

                <div class="container-fluid no-padding">

                    <div class="row">

                        <div class="col-lg-12 margin-three-bottom sm-margin-30px-bottom xs-margin-20px-bottom text-center wow fadeInUp">

                            <h3 class="alt-font font-weight-600 text-very-large margin-40px-bottom text-uppercase text-purple">O que eles dizem</h3>

                        </div>  

                    </div>

                    <div class="width-100 margin-one-lr margin-20px-top sm-margin-20px-top xs-margin-20px-top flt-left">

                        <div class="swiper-container swiper-pagination-bottom black-move blog-slider swiper-three-slides">

                            <div class="swiper-wrapper">


                                <div class="col-md-4 col-sm-6 col-xs-12 swiper-slide sm-margin-four-bottom wow fadeInDown">

                                    <p id="website-funcional" class="width-90 xs-margin-15px-bottom xs-width-100"><strong>&quot;</strong>Pensando em fazer um website diferente e funcional escolhemos o Rodrigo. Ele nos entregou o website conforme combinado e sempre podemos contar com ele. Atendimento TOP é o que Rodrigo Marafigo oferece ao cliente. <strong>&quot;</strong></p>
                                    <span class="text-large alt-font width-100 md-width-100 xs-width-100 margin-0px-bottom margin-10px-top display-block"><span class="text-extra-dark-gray fts-cd"><strong>Jorge Ortiz</strong><br />Diretor</span></span>
                                    <span class="text-medium-gray text-uppercase text-extra-small"><span class="cursor-default text-medium-gray">Legado Energias Renováveis</span></span>

                                </div>


                                <div class="col-md-4 col-sm-6 col-xs-12 swiper-slide sm-margin-four-bottom wow fadeInDown">

                                    <p id="atingiu-objetivo" class="width-90 xs-margin-15px-bottom xs-width-100"><strong>&quot;</strong>Nós da CargoModal ficamos muito satisfeitos com o trabalho desenvolvido pelo Rodrigo, pois atingiu nosso objetivo!<strong>&quot;</strong></p>
                                    <span class="text-large alt-font width-100 md-width-100 xs-width-100 margin-0px-bottom margin-10px-top display-block"><span class="text-extra-dark-gray fts-cd"><strong>Anderson Ferraz</strong><br />Diretor Comercial</span></span>
                                    <span class="text-medium-gray text-uppercase text-extra-small"><span class="cursor-default text-medium-gray">CargoModal Transportes</span></span>

                                </div>


                                <div class="col-md-4 col-sm-6 col-xs-12 swiper-slide sm-margin-four-bottom wow fadeInDown">

                                    <p id="profissionalismo-agradecer" class="width-90 xs-margin-15px-bottom xs-width-100"><strong>&quot;</strong>A atenção e o profissionalismo do Rodrigo são admiráveis! Ele surpreendeu a mim e a toda a equipe com a resultado final do projeto... Superou todas as nossas expectativas, nós só temos a agradecer!<strong>&quot;</strong></p>
                                    <span class="text-large alt-font width-100 md-width-100 xs-width-100 margin-0px-bottom margin-10px-top display-block"><span class="text-extra-dark-gray fts-cd"><strong>Claudio Canelada</strong><br />Diretor executivo</span></span>
                                    <span class="text-medium-gray text-uppercase text-extra-small"><span class="cursor-default text-medium-gray">Ipê Azul Construções e Empreendimentos Ltda</span></span>

                                </div>


                                <div class="col-md-4 col-sm-6 col-xs-12 swiper-slide sm-margin-four-bottom wow fadeInDown">

                                    <p id="empresa-desenvolvimento-site" class="width-90 xs-margin-15px-bottom xs-width-100"><strong>&quot;</strong>Em busca de uma empresa para desenvolvimento de nosso site, encontramos o Rodrigo, com atenção, paciência e rapidez desenvolveu um projeto moderno e funcional, como queríamos. Recomendo.<strong>&quot;</strong></p>
                                    <span class="text-large alt-font width-100 md-width-100 xs-width-100 margin-0px-bottom margin-10px-top display-block"><span class="text-extra-dark-gray fts-cd"><strong>Joberson Trespach</strong><br />Consultor</span></span>
                                    <span class="text-medium-gray text-uppercase text-extra-small"><span class="cursor-default text-medium-gray">Obatrade</span></span>

                                </div>

                            </div>
                    
                            <div class="swiper-pagination swiper-pagination-three-slides height-auto dpl-blc"></div>

                        </div>

                    </div>

                    <div class="width-100 text-center sm-padding-20px-top flt-left">

                        <a href="/depoimentos" id="ver-depoimentos" class="btn btn-medium btn-deep-pink md-margin-15px-bottom mrg-lf">Ver + depoimentos</a>

                    </div>

                </div>

            </section>

            <?php

                $pagina = "home";  // necessario por causa do botao do whatsapp no include abaixo

                include("footer.php");

            ?>

        </div>

        <?php

            include("js.php");

        ?>

</body>
</html>