<!DOCTYPE html>
<html lang="pt-br">
<head>

        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">


        <title>Serviços</title>
        <meta name="description" content="Serviços de Mídias sociais, web design e tecnologia: criação de conteúdo para as redes sociais, criação de site e landing page, e-mail marketing, anúncios patrocinados no Google e redes sociais.">
	    <meta name="robots" content="index, follow">	
        <meta name="author" content="Web designer Rodrigo Marafigo">



        <meta property="og:locale" content="pt_BR">
        <meta property="og:url" content="https://rodrigomarafigo.com.br/servicos">
        <meta property="og:title" content="Serviços">
        <meta property="og:site_name" content="Rodrigo Marafigo - Criação de Sites e Marketing Digital">
        <meta property="og:description" content="Serviços de Mídias sociais, web design e tecnologia: criação de conteúdo para as redes sociais, criação de site e landing page, e-mail marketing, anúncios patrocinados no Google e redes sociais.">
        <meta property="og:image" content="/img/ilustracao_desenvolvimento.jpg">
        <meta property="og:type" content="website">

        <?php

            include("ico.php");

            include("style.php");

        ?>

</head>
<body>

    <?php

        include("nav.php");

    ?>



        <div class="sidebar-wrapper mobile-height">


            <section class="wow fadeIn">

                <div class="container-fluid wow fadeInRight">

                    <div class="row sm-padding-100px-top">

                        <div class="col-lg-11 col-md-11 col-sm-12 col-xs-12 center-col no-margin-bottom sm-padding-20px-top text-center wow fadeInDown">

                            <h1 class="alt-font font-weight-700 margin-10px-bottom text-uppercase text-multi-large text-purple">Serviços</h1>

                        </div>  

                    </div>

                    <div class="row">

                        <div class="col-lg-6 col-md-8 col-sm-8 col-xs-12 center-col text-center margin-80px-bottom wow fadeInDown">

                            <div class="position-relative overflow-hidden width-100">

                                <h2 class="text-small text-outside-line-full alt-font font-weight-600 text-uppercase text-purple">Soluções Web</h2>

                            </div>

                        </div>

                    </div>


                    <div class="row equalize sm-equalize-auto text-center padding-one-lr">



                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom ar_svc wow fadeInUp bd_bg criacao_de_site">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h3 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">CRIAÇÃO DE SITES</h3>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="criacao-de-site-e-landing-page" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Criação de sites sob medida, com o que há de mais <strong>moderno</strong> em <strong>tecnologia</strong> web. Um único investimento e total autonomia pelo cliente.

                                </p>

                            </div>

                        </div>



                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg google_e_midias_sociais">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h3 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">REDES SOCIAIS E GOOGLE</h3>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="google-e-midias-digitais" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Criação de conteúdo para o <strong>Instagram</strong>, <strong>Facebook</strong>, <strong>LinkedIn</strong> e status do <strong>WhatsApp</strong>. Anúncios patrocinados nestas redes e nos resultados de busca do <strong>Google</strong>.

                                </p>

                            </div>

                        </div>



                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg integracao_do_whatsapp">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h3 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">WHATSAPP</h3>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="email-marketing" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Integração de um botão do WhatsApp nas principais páginas do <strong>seu site</strong> ou <strong>loja virtual</strong>.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg email_marketing">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h3 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">E-MAIL MARKETING</h3>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="email-marketing" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Tenha uma mala direta com a <strong>cara da sua empresa</strong>, personalizado e atualizado por você.

                                </p>

                            </div>

                        </div>




                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg emails_eficientes">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h3 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">E-MAILS EFICIENTES</h3>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="emails-eficientes" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Nunca mais tenha dor de cabeça com os e-mails na sua empresa e <strong>foque nos negócios</strong>.

                                </p>

                            </div>

                        </div>



                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg seo">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h3 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">SEO</h3>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="seo" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Torne o <strong>seu site</strong> mais relevante para o Google através da boa otimização dos códigos.

                                </p>

                            </div>

                        </div>




                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg integracao_do_instagram">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h3 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">INT. DO INSTAGRAM</h3>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="integracao-do-instagram" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Tenha as <strong>postagens</strong> do seu feed do Instagram atualizadas em tempo real em seu site.

                                </p>

                            </div>

                        </div>



                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg assinatura_de_email">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h4 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">ASSINATURA DE E-MAIL</h4>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="assinatura-de-email" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Tenha uma assinatura profissional com links e mostre maior <strong>credibilidade</strong> e profissionalismo.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom ar_svc wow fadeInUp bd_bg criacao_de_site">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h3 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">LANDING PAGE</h3>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="criacao-de-site-e-landing-page" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Criação de landing pages estratégicas, com o que há de mais <strong>eficiente</strong> em <strong>SEO</strong>.

                                </p>

                            </div>

                        </div>



                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg formularios_de_contato">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h4 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">FORMULÁRIOS</h4>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="formularios-de-contato" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Receba orçamentos, pesquisas de satisfação e etc. através de <strong>formulários</strong> em <strong>seu site</strong>.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg integracao_do_sitemap">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h4 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">INT. DO SITEMAP</h4>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="integracap-do-sitemap" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Inclua o sitemap em seu site e permita que buscadores como o <strong>Google</strong> encontre o seu site.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg integracao_do_google_tag_manager">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h4 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">GOOGLE TAG MANAGER</h4>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="integracao-do-google-tag-manager" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Tenha o auxílio do Google Tag Manager para <strong>seu site</strong> e identifique pontos de melhoria.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg integracao_de_chat_online">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h5 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">INT. DE CHAT ONLINE</h5>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="integracao-de-chat-online" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Converse com seus visitantes em <strong>tempo real</strong> em seu site e possibilite novos clientes.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg integracao_do_disqus">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h5 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">INT. DO DISQUS</h5>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="integracao-do-disqus" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Envolva o público do seu <strong>Blog</strong> com o plug-in de comentários <strong>favorito</strong> da internet.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg integracao_do_facebook">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h5 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">INT. DO FACEBOOK</h5>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="integracao-do-facebook" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Tenha as <strong>postagens</strong> do seu feed do Facebook atualizadas em tempo real em seu site.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg integracao_do_google_analytics">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h5 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">GOOGLE ANALYTICS</h5>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="integracao-do-google-analytics" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Veja as visitas ao seu site <em>(cidades, tempo e etc.)</em> com a <strong>principal</strong> ferramenta de análises.

                                </p>

                            </div>

                        </div>
                        


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg integracao_do_youtube">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h5 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">INT. DO YOUTUBE</h5>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="integracao-do-youtube" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Exiba seus vídeos do Youtube nas páginas do <strong>seu site</strong> através da integração que realizamos.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg instalacao_do_pixel_do_facebook">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h5 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">INST. PIXEL DO FACEBOOK</h5>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="instalacao-do-pixel-do-facebook" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Acompanhe o <strong>desempenho</strong> dos cliques nos seus anúncios no Facebook através do pixel.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg faq">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h6 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">FAQ (PERGUNTAS FREQUENTES)</h6>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="faq-perguntas-frequentes" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Uma FAQ é capaz de <strong>esclarecer</strong> diversas <strong>dúvidas</strong> aos clientes e evitar ligações à empresa.

                                </p>

                            </div>

                        </div>


                        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 margin-30px-bottom area_servico wow fadeInUp bd_bg servicos_de_programacao">

                            <div class="col-lg-11 center-col display-table titulo_servico">

                                    <div class="display-table-cell vertical-align-middle">

                                        <h6 class="text-white alt-font font-weight-700 h1_svc no-margin padding-three-lr">DIVERSOS</h6>

                                    </div>

                            </div>

                            <div class="col-lg-12 center-col bg-white no-margin no-padding bdr-4px">

                                <p id="servicos-de-programacao" class="alt-font text-extra-dark-gray no-margin-bottom padding-five-lr padding-eight-tb alt_rsm">

                                    Solicite ajustes ou correções de problemas em seu site para que tudo funcine <strong>perfeitamente</strong>.

                                </p>

                            </div>

                        </div>


                    </div>

                </div>

            </section>

            <?php

                include("footer.php");

            ?>

        </div>

        <?php

            include("js.php");

        ?>

</body>
</html>